#!/bin/sh
#
#################################################################
# Script um aus dem DVB-Datenstrom die Codierungen zu bestimmen #
#   Kleinere Erweiterungen von BPanther  ------  19. Mai 2014   #
#################################################################
UseMsgBox=0
if [ -f /bin/msgbox ]; then
	# "msgbox" statt "echo" benutzen
	UseMsgBox=1
	# Einblendzeit der Meldungen bei msgbox in Sekunden
	OSDTime=300
fi
# EMM-Daten (experimentell)
EMM=0
#################################################################
Ausgabe() {
	if [ "$UseMsgBox" == "1" ]; then
		msgbox title="~cVerwendete Codierungs-Systeme" popup="$MSG" timeout=$OSDTime
	else
		echo -e "Verwendete Codierungs-Systeme\n---------------------------------------\n$MSG"
	fi
}
BINARY_DIR=/usr/bin
if [ ! -e $BINARY_DIR/dvbsnoop ]; then
	BINARY_DIR=$(dirname $(readlink -f $0))
	if [ ! -e $BINARY_DIR/dvbsnoop ]; then
		MSG="FEHLER: dvbsnoop nicht gefunden!"
		Ausgabe
		exit 1
	fi
fi
#################################################################
# MSG=`$(dirname $(readlink -f $0))/dvbsnoop -n 1 1 -timeout 5000 |grep CA_system_ID |cut -f 2- -d "x" |sed -e 's/]//g' |sed -e 's/)  \[=/h:/g'`
# Nagra CA_systemID 0x1801, CA_PID 0x1001 - RAW-EMM
# dvbsnoop -pd 0 -ph 2 -f 0x82.70.6c -m 0xFF 0x1001
CAID=`$BINARY_DIR/dvbsnoop -n 1 1 -timeout 15000 | grep CA_system_ID | cut -f 2- -d "x" | sed -e 's/]//g' | sed -e 's/)  \[=/ =>/g'`
if [ ! "$CAID" ]; then
	CAID="Kein Codierungs-System gefunden."
else
	if [ "$EMM" == "1" ]; then
		CAPID=`$BINARY_DIR/dvbsnoop -n 1 1 -timeout 15000 | grep CA_PID | cut -f 2- -d "x" | sed -e 's/]//g' | sed -e 's/)//g'`
		[ "$UseMsgBox" == "1" ] && CAPID="~n$CAPID" || CAPID="\n$CAPID"
	fi
fi
MSG="$CAID$CAPID"
Ausgabe
exit 0
